# 服务框架

## 微服务架构
在一个微服务架构中，你把应用拆分成不同的模块（component）。
service之间的通信机制可以是多种格式的，通常是HTTP 或者 RPC（以及事件发布订阅的方式）

## 技术体系
接入层: nginx
网关层：
业务服务层：聚合服务，基础服务
支撑服务：注册发现 集中配置 容错限流 认证授权 日志聚合 监控报警 后台服务（DB,MQ,Cache,Job）
平台服务 发布系统，集群资源调度，镜像治理，资源治理，IAM(权限控制)
基础设施层 计算 网络 存储 监控 安全 IDC(数据中心)

## 互联网架构演变

#### 多应用架构
多应用架构很简单，就是把原来的应用按照业务特点拆分成多个应用。

#### 分布式架构
对于一个大型的互联网系统，一般会包含多个应用，而且应用之间往往还存在共同的业务，并且应用之间还存在调用关系。
![分布式架构](https://img-blog.csdn.net/20170103142540155)



## 早期服务
1. 基于数据库实现服务
2. 基于redis实现服务

缺点
1. 存储层未隔离，数据不可迁移调整，耦合性极高
2. 扩展性差，可维护性差

## 基于PHP代码（类、函数）实现服务
1. 客户端必须include/require一个文件
2. 代码修改必须通知所有业务方升级
3. 可能存在不同版本的兼容问题
4. 无法跨语言，不支持C++、Java等其他语言程序

## HTTP + JSON的Web API
优点
1. 解决了耦合问题
缺点
1. HTTP不支持并发
2. 长连接支持差
3. 不支持订阅与消息主动推送

## Swoole
服务名 + 接口名 + 参数 + 环境信息